// File          : SaveAjr.java
// Description   : Runnable to save image in thread.
// Date          : 14th July 2008
// Last Modified : 14th July 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.*;
import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Runnable to save image in AJR format.
 */
public class SaveAjr implements Runnable
{
   private SaveAjr()
   {
   }

   public SaveAjr(JDRFrame frame, String filename, float version, JDRGroup image)
   {
      this(frame, filename, version, image, null);
   }

   public SaveAjr(JDRFrame frame, String filename, float version, JDRGroup image,
      CanvasSettings settings)
   {
      jdrFrame = frame;
      fileName = filename;
      ajrVersion = version;
      ajrImage = image;
      canvasSettings = settings;
   }

   public void run()
   {
      jdrFrame.setIoInProgress(true);
      boolean success = false;

      JpgfDraw app = jdrFrame.getApplication();

      app.showMessageFrame(
         JDRResources.getStringWithValue("info.saving", fileName));

      Cursor oldCursor = jdrFrame.getCursor();
      jdrFrame.setCursor(
         Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

      app.setStatusInfo(
         JDRResources.getStringWithValue("info.saving", fileName));

      PrintWriter out;

      try
      {
         out = new PrintWriter(new File(fileName));
      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame, new String[]
         {JDRResources.getStringWithValue("error.io.open", fileName),
          e.getMessage()});

         jdrFrame.setIoInProgress(false);
         app.hideMessageFrame();

         jdrFrame.setCursor(oldCursor);
         app.setTool(jdrFrame.currentTool());

         return;
      }

      try
      {
         if (canvasSettings != null)
         {
            AJR.save(ajrImage, canvasSettings, out, ajrVersion);
         }
         else
         {
            AJR.save(ajrImage, out, ajrVersion);
         }

         success = true;
      }
      catch (IOException e)
      {
         JDRResources.error(jdrFrame, new String[]
         {JDRResources.getString("error.io.save"),
          e.getMessage()});
      }
      catch (Exception e)
      {
         JDRResources.internalError(jdrFrame, e);
      }


      jdrFrame.setIoInProgress(false);
      app.hideMessageFrame();

      out.close();

      if (success)
      {
         jdrFrame.setFilename(fileName);
         jdrFrame.markAsSaved();

         jdrFrame.addRecentFile(fileName);
      }

      jdrFrame.setCursor(oldCursor);
      app.setTool(jdrFrame.currentTool());
   }

   private String fileName;
   private float ajrVersion;
   private JDRGroup ajrImage;
   private JDRFrame jdrFrame;
   private CanvasSettings canvasSettings;
}
