// File          : PathAction.java
// Description   : Action for path objects
// Date          : 2012-03-14
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.event.*;

import java.awt.geom.GeneralPath;
import java.awt.BasicStroke;

import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

public class PathAction extends JDRAction
{
   public PathAction(JDRFrame frame)
   {
      super();
      this.frame = frame;
      app = frame.getApplication();
   }

   public void actionPerformed(ActionEvent evt)
   {
      int id = getActionId();

      if (id == -1 && evt instanceof JDRActionEvent)
      {
         id = ((JDRActionEvent)evt).getActionId();
      }

      if (id == -1)
      {
         return;
      }

      switch (id)
      {
         case ACTION_EDIT:
            app.setEditPathState(frame, true);
         return;
         case ACTION_LINE_PAINT:
            app.displayLinePaintChooser();
         return;
         case ACTION_FILL_PAINT:
            app.displayFillPaintChooser();
         return;
         case ACTION_PEN_WIDTH:
            app.displayLineWidthChooser();
         return;
         case ACTION_DASH:
            app.displayDashPatternChooser();
         return;
         case ACTION_CAP_BUTT:
            frame.setSelectedCapStyle(BasicStroke.CAP_BUTT);
         return;
         case ACTION_CAP_ROUND:
            frame.setSelectedCapStyle(BasicStroke.CAP_ROUND);
         return;
         case ACTION_CAP_SQUARE:
            frame.setSelectedCapStyle(BasicStroke.CAP_SQUARE);
         return;
         case ACTION_JOIN:
            app.displayJoinStyleChooser();
         return;
         case ACTION_MARKER_ALL:
            app.displayAllMarkerChooser();
         return;
         case ACTION_MARKER_START:
            app.displayStartMarkerChooser();
         return;
         case ACTION_MARKER_MID:
            app.displayMidMarkerChooser();
         return;
         case ACTION_MARKER_END:
            app.displayEndMarkerChooser();
         return;
         case ACTION_WIND_EVEN_ODD:
            frame.setSelectedWindingRule(GeneralPath.WIND_EVEN_ODD);
         return;
         case ACTION_WIND_NON_ZERO:
            frame.setSelectedWindingRule(GeneralPath.WIND_NON_ZERO);
         return;
      }
   }

   public JDRMenuItem createEditItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.edit"),
         JDRResources.getChar("selectedpath.edit.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_EDIT);

      return item;
   }

   public JDRMenuItem createLinePaintItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.line_colour"),
         JDRResources.getChar("selectedpath.line_colour.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_LINE_PAINT);

      return item;
   }

   public JDRMenuItem createFillPaintItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.fill_colour"),
         JDRResources.getChar("selectedpath.fill_colour.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_FILL_PAINT);

      return item;
   }

   public JDRMenuItem createPenWidthItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.linewidth"),
         JDRResources.getChar("selectedpath.linewidth.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_PEN_WIDTH);

      return item;
   }

   public JDRMenuItem createDashItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.dashpattern"),
         JDRResources.getChar("selectedpath.dashpattern.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_DASH);

      return item;
   }

   public JDRRadioButtonMenuItem createButtCapItem()
   {
      JDRRadioButtonMenuItem item = new JDRRadioButtonMenuItem(
         JDRResources.getString("edit.path.style.capstyle.butt"),
         JDRResources.getChar("edit.path.style.capstyle.butt.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_CAP_BUTT);

      return item;
   }

   public JDRRadioButtonMenuItem createRoundCapItem()
   {
      JDRRadioButtonMenuItem item = new JDRRadioButtonMenuItem(
         JDRResources.getString("edit.path.style.capstyle.round"),
         JDRResources.getChar("edit.path.style.capstyle.round.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_CAP_ROUND);

      return item;
   }

   public JDRRadioButtonMenuItem createSquareCapItem()
   {
      JDRRadioButtonMenuItem item = new JDRRadioButtonMenuItem(
         JDRResources.getString("edit.path.style.capstyle.square"),
         JDRResources.getChar("edit.path.style.capstyle.square.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_CAP_SQUARE);

      return item;
   }

   public JDRMenuItem createJoinItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.joinstyle"),
         JDRResources.getChar("selectedpath.joinstyle.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_JOIN);

      return item;
   }

   public JDRMenuItem createMarkerAllItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.marker.all"),
         JDRResources.getChar("selectedpath.marker.all.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.all_markers"));

      item.addActionListener(this);
      item.setActionId(ACTION_MARKER_ALL);

      return item;
   }

   public JDRMenuItem createMarkerStartItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.marker.start"),
         JDRResources.getChar("selectedpath.marker.start.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_MARKER_START);

      return item;
   }

   public JDRMenuItem createMarkerMidItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.marker.mid"),
         JDRResources.getChar("selectedpath.marker.mid.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_MARKER_MID);

      return item;
   }

   public JDRMenuItem createMarkerEndItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedpath.marker.end"),
         JDRResources.getChar("selectedpath.marker.end.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_MARKER_END);

      return item;
   }

   public JDRRadioButtonMenuItem createWindEvenOddItem()
   {
      JDRRadioButtonMenuItem item = new JDRRadioButtonMenuItem(
         JDRResources.getString("edit.path.style.windingrule.evenodd"),
         JDRResources.getChar("edit.path.style.windingrule.evenodd.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_WIND_EVEN_ODD);

      return item;
   }

   public JDRRadioButtonMenuItem createWindNonZeroItem()
   {
      JDRRadioButtonMenuItem item = new JDRRadioButtonMenuItem(
         JDRResources.getString("edit.path.style.windingrule.nonzero"),
         JDRResources.getChar("edit.path.style.windingrule.nonzero.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_WIND_NON_ZERO);

      return item;
   }

   private JpgfDraw app;
   private JDRFrame frame;

   public static final int ACTION_EDIT            = 0;
   public static final int ACTION_LINE_PAINT      = 1;
   public static final int ACTION_FILL_PAINT      = 2;
   public static final int ACTION_PEN_WIDTH       = 3;
   public static final int ACTION_DASH            = 4;
   public static final int ACTION_CAP_BUTT        = 5;
   public static final int ACTION_CAP_ROUND       = 6;
   public static final int ACTION_CAP_SQUARE      = 7;
   public static final int ACTION_JOIN            = 8;
   public static final int ACTION_MARKER_ALL      = 9;
   public static final int ACTION_MARKER_START    = 10;
   public static final int ACTION_MARKER_MID      = 11;
   public static final int ACTION_MARKER_END      = 12;
   public static final int ACTION_WIND_EVEN_ODD   = 13;
   public static final int ACTION_WIND_NON_ZERO   = 14;
}
