// File          : LoadAction.java
// Description   : Action for loading JDR/AJR files
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdrresources.*;

/**
 * Action for loading JDR/AJR files.
 * @author Nicola L C Talbot
 */
public class LoadAction extends AbstractAction
{
   public LoadAction(JpgfDraw application, String filename, 
      int index, Vector<String> recentFiles)
   {
      application_ = application;
      filename_ = filename;
      list = recentFiles;
      index_ = index;
   }

   public void actionPerformed(ActionEvent evt)
   {
      JDRFrame frame = application_.getCurrentFrame();

      File f = new File(filename_);

      if (!f.exists())
      {
         JDRResources.error(application_, 
                       JDRResources.getString("error.io.not_exists"));

         list.remove(index_);

         return;
      }

      if (frame == null || !frame.newImage)
      {
         application_.addFrame(filename_);
      }
      else
      {
         frame.load(filename_);
      }
   }

   private JpgfDraw application_;
   private String filename_;
   private int index_;
   private Vector<String> list;
}
