// File          : JpgfDrawSettings.java
// Purpose       : Application settings
// Date          : 1st February 2006
// Last Modified :95th June 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.*;
import uk.ac.uea.cmp.nlct.jdr.*;

public class JpgfDrawSettings
{
   public JpgfDrawSettings()
   {
      showToolBar   = true;
      showStatus    = true;
      antialias     = false;
      renderquality = false;
      enableDragScale = false;
      startDir = ".";
      String home = System.getenv("HOME");
      if (home != null)
      {
         startDir = home;
      }
      else
      {
         home = System.getenv("USERPROFILE");
         if (home != null) startDir = home;
      }
      startDirType=STARTDIR_LAST;
      saveJDRsettings=true;
      useJDRsettings=true;
      stroke = new JDRBasicStroke();
      linePaint = new JDRColor(Color.black);
      fillPaint = new JDRTransparent();
      textPaint = new JDRColor(Color.black);
      previewBitmaps = true;
      autoUpdateAnchors=true;
      autoEscapeSpChars=true;
   }

   public boolean showToolBar=true;
   public boolean showStatus=true;
   public boolean antialias=false, renderquality=false;
   public boolean enableDragScale=false;
   public String startDir;
   public int startDirType;
   public static final int STARTDIR_CWD=0, STARTDIR_LAST=1,
      STARTDIR_NAMED=2;

   public boolean saveJDRsettings=true;
   public boolean useJDRsettings=true;
   public boolean warnOnOldJdr=true;

   public int initSettings=INIT_LAST;

   public static final int INIT_DEFAULT=0, INIT_LAST=1,
      INIT_USER=2;

   public JDRBasicStroke stroke;
   public JDRPaint linePaint, fillPaint, textPaint;

   public String fontFamily="SansSerif";
   public int fontSeries = JDRFont.SERIES_MEDIUM;
   public int fontShape  = JDRFont.SHAPE_UPRIGHT;
   public int fontSize=10;

   public String latexFontFamily="\\sffamily";
   public String latexFontSeries="\\mdseries";
   public String latexFontSize="\\normalsize";
   public String latexFontShape="\\upshape";

   public boolean updateLaTeXFonts=true;
   public boolean autoUpdateAnchors=true;
   public boolean autoEscapeSpChars=false;

   public int pgfHalign = JDRText.PGF_HALIGN_LEFT;
   public int pgfValign = JDRText.PGF_VALIGN_BASE;

   public boolean previewBitmaps;

   public Robot robot=null;
}

