// File          : GeneralAction.java
// Description   : Action for general objects
// Date          : 2012-03-14
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.event.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;

import uk.ac.uea.cmp.nlct.jdrresources.*;

public class GeneralAction extends JDRAction
{
   public GeneralAction(JDRFrame frame)
   {
      super();
      this.frame = frame;
      this.app = frame.getApplication();
   }

   public void actionPerformed(ActionEvent evt)
   {
      int id = getActionId();

      if (id == -1 && evt instanceof JDRActionEvent)
      {
         id = ((JDRActionEvent)evt).getActionId();
      }

      if (id == -1)
      {
         return;
      }

      switch (id)
      {
         case ACTION_DESCRIPTION:
            JDRCompleteObject object = frame.getSelectedObject();
            app.displayObjectDescriptionDialog(object);
         return;
         case ACTION_CUT:
            frame.cutSelectedPaths();
         return;
         case ACTION_COPY:
            frame.copySelectedPaths();
         return;
         case ACTION_PASTE:
            frame.pasteSelectedPaths();
         return;
         case ACTION_SELECT_ALL:
            frame.selectAll();
         return;
         case ACTION_DESELECT_ALL:
            frame.deselectAll();
         return;
         case ACTION_GROUP:
            frame.group();
         return;
         case ACTION_UNGROUP:
            frame.ungroup();
         return;
         case ACTION_ALIGN_LEFT:
            frame.leftAlign();
         return;
         case ACTION_ALIGN_CENTRE:
            frame.centreAlign();
         return;
         case ACTION_ALIGN_RIGHT:
            frame.rightAlign();
         return;
         case ACTION_ALIGN_TOP:
            frame.topAlign();
         return;
         case ACTION_ALIGN_MIDDLE:
            frame.middleAlign();
         return;
         case ACTION_ALIGN_BOTTOM:
            frame.bottomAlign();
         return;
         case ACTION_IMAGE_DESCRIPTION:
            app.displayImageDescriptionDialog(frame.getAllPaths());
         return;
         case ACTION_FIND:
            app.displayFindByDescriptionDialog();
         return;
      }
   }

   public JDRMenuItem createDescriptionItem(String label)
   {
      return createDescriptionItem(label, null);
   }

   public JDRMenuItem createDescriptionItem(String label, String tooltipLabel)
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString(label),
         JDRResources.getChar(label+".mnemonic"));

      if (tooltipLabel != null)
      {
         item.setToolTipText(JDRResources.getString(tooltipLabel));
      }

      item.addActionListener(this);
      item.setActionId(ACTION_DESCRIPTION);

      return item;
   }

   public JDRMenuItem createImageDescriptionItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("none.description"),
         JDRResources.getChar("none.description.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_IMAGE_DESCRIPTION);

      return item;
   }

   public JDRMenuItem createCutItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.cut"),
         JDRResources.getChar("selected.cut.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.cut"));

      item.addActionListener(this);
      item.setActionId(ACTION_CUT);
      item.setAccelerator(KEY_CUT);

      return item;
   }

   public JDRMenuItem createCopyItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.copy"),
         JDRResources.getChar("selected.copy.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.copy"));

      item.addActionListener(this);
      item.setActionId(ACTION_COPY);
      item.setAccelerator(KEY_COPY);

      return item;
   }

   public JDRMenuItem createPasteItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.paste"),
         JDRResources.getChar("selected.paste.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.paste"));

      item.addActionListener(this);
      item.setActionId(ACTION_PASTE);
      item.setAccelerator(KEY_PASTE);

      return item;
   }

   public JDRMenuItem createSelectAllItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.select_all"),
         JDRResources.getChar("selected.select_all.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.select_all"));

      item.addActionListener(this);
      item.setActionId(ACTION_SELECT_ALL);
      item.setAccelerator(KEY_SELECT_ALL);

      return item;
   }

   public JDRMenuItem createDeselectAllItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.deselect_all"),
         JDRResources.getChar("selected.deselect_all.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_DESELECT_ALL);
      item.setAccelerator(KEY_DESELECT_ALL);

      return item;
   }

   public JDRMenuItem createGroupItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.group"),
         JDRResources.getChar("selected.group.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.group"));

      item.addActionListener(this);
      item.setActionId(ACTION_GROUP);
      item.setAccelerator(KEY_GROUP);

      return item;
   }

   public JDRMenuItem createUngroupItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selected.ungroup"),
         JDRResources.getChar("selected.ungroup.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.ungroup"));

      item.addActionListener(this);
      item.setActionId(ACTION_UNGROUP);
      item.setAccelerator(KEY_UNGROUP);

      return item;
   }

   public JDRMenuItem createLeftAlignItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("transform.justify.left"),
         JDRResources.getChar("transform.justify.left.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ALIGN_LEFT);

      return item;
   }

   public JDRMenuItem createCentreAlignItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("transform.justify.centre"),
         JDRResources.getChar("transform.justify.centre.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ALIGN_CENTRE);

      return item;
   }

   public JDRMenuItem createRightAlignItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("transform.justify.right"),
         JDRResources.getChar("transform.justify.right.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ALIGN_RIGHT);

      return item;
   }

   public JDRMenuItem createTopAlignItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("transform.justify.top"),
         JDRResources.getChar("transform.justify.top.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ALIGN_TOP);

      return item;
   }

   public JDRMenuItem createMiddleAlignItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("transform.justify.middle"),
         JDRResources.getChar("transform.justify.middle.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ALIGN_MIDDLE);

      return item;
   }

   public JDRMenuItem createBottomAlignItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("transform.justify.bottom"),
         JDRResources.getChar("transform.justify.bottom.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_ALIGN_BOTTOM);

      return item;
   }

   public JDRMenuItem createFindItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("none.find_by_description"),
         JDRResources.getChar("none.find_by_description.mnemonic"));

      item.addActionListener(this);
      item.setActionId(ACTION_FIND);

      return item;
   }

   private JpgfDraw app;
   private JDRFrame frame;

   public static final KeyStroke KEY_GROUP = 
      KeyStroke.getKeyStroke(KeyEvent.VK_G, InputEvent.CTRL_MASK);
   public static final KeyStroke KEY_UNGROUP = 
      KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_MASK);
   public static final KeyStroke KEY_SELECT_ALL = 
      KeyStroke.getKeyStroke(KeyEvent.VK_A, InputEvent.CTRL_MASK);
   public static final KeyStroke KEY_DESELECT_ALL = 
      KeyStroke.getKeyStroke(KeyEvent.VK_A,
         InputEvent.CTRL_MASK+InputEvent.SHIFT_MASK);
   public static final KeyStroke KEY_CUT = 
      KeyStroke.getKeyStroke(KeyEvent.VK_X, InputEvent.CTRL_MASK);
   public static final KeyStroke KEY_COPY = 
      KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_MASK);
   public static final KeyStroke KEY_PASTE = 
      KeyStroke.getKeyStroke(KeyEvent.VK_V, InputEvent.CTRL_MASK);

   public static final int ACTION_DESCRIPTION  = 0;
   public static final int ACTION_CUT          = 1;
   public static final int ACTION_COPY         = 2;
   public static final int ACTION_PASTE        = 3;
   public static final int ACTION_SELECT_ALL   = 4;
   public static final int ACTION_DESELECT_ALL = 5;
   public static final int ACTION_GROUP        = 6;
   public static final int ACTION_UNGROUP      = 7;
   public static final int ACTION_ALIGN_LEFT   = 8;
   public static final int ACTION_ALIGN_CENTRE = 9;
   public static final int ACTION_ALIGN_RIGHT  = 10;
   public static final int ACTION_ALIGN_TOP    = 11;
   public static final int ACTION_ALIGN_MIDDLE = 12;
   public static final int ACTION_ALIGN_BOTTOM = 13;
   public static final int ACTION_IMAGE_DESCRIPTION = 14;
   public static final int ACTION_FIND              = 15;
}
