// File          : BitmapAction.java
// Description   : Action for bitmap objects
// Date          : 2012-03-15
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import uk.ac.uea.cmp.nlct.jdrresources.*;

public class BitmapAction extends JDRAction
{
   public BitmapAction(JDRFrame frame)
   {
      super();
      this.frame = frame;
      this.app = frame.getApplication();
   }

   public void actionPerformed(ActionEvent evt)
   {
      int id = getActionId();

      if (id == -1 && evt instanceof JDRActionEvent)
      {
         id = ((JDRActionEvent)evt).getActionId();
      }

      if (id == -1)
      {
         return;
      }

      switch (id)
      {
         case ACTION_PROP:
            app.displayBitmapPropertiesChooser();
         return;
         case ACTION_INSERT:
            app.displayInsertBitmapChooser(frame);
         return;
      }
   }

   public JDRMenuItem createBitmapPropertiesItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedbitmap.properties"),
         JDRResources.getChar("selectedbitmap.properties.mnemonic"));

      item.setToolTipText(JDRResources.getString("tooltip.bitmap.properties"));

      item.addActionListener(this);

      item.setActionId(ACTION_PROP);

      return item;
   }

   public JDRMenuItem createInsertBitmapItem()
   {
      JDRMenuItem item = new JDRMenuItem(
         JDRResources.getString("selectedbitmap.insert"),
         JDRResources.getChar("selectedbitmap.insert.mnemonic"));

      item.addActionListener(this);

      item.setActionId(ACTION_INSERT);

      return item;
   }

   private JpgfDraw app;
   private JDRFrame frame;

   public static final int ACTION_PROP   = 0;
   public static final int ACTION_INSERT = 1;
}
