// File        : JDRViewPanel.java
// Description : Panel used to display JDR/AJR image
// Date        : 4th June 2008
// Author      : Nicola L C Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdrview;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;

import uk.ac.uea.cmp.nlct.jdr.*;

/**
 * Panel used to display JDR/AJR image.
 * @author Nicola L C Talbot
 */
public class JDRViewPanel extends JPanel 
{
   /**
    * Creates instance of this panel.
    * @param application the application using this panel
    */
   public JDRViewPanel(JDRView application)
   {
      super();

      app = application;

      setBackground(Color.lightGray);

      ToolTipManager toolTipManager = ToolTipManager.sharedInstance();

      toolTipManager.registerComponent(this);
   }

   public String getToolTipText(MouseEvent e)
   {
      JDRGroup image = app.getImage();

      if (image == null)
      {
         return null;
      }

      // Get mouse position
      Point p = e.getPoint();

      double mag = app.getCurrentMagnification();

      Point2D point = new Point2D.Double(p.x/mag, p.y/mag);

      String text = image.description;

      // Is there anything located at this position?

      for (int i = image.size()-1; i >= 0; i--)
      {
         JDRCompleteObject object = image.get(i);

         BBox box = object.getBBox();

         if (object.contains(point))
         {
            text = object.description;

            if (text != null)
            {
               break;
            }
         }
      }

      if (text == "")
      {
         return null;
      }

      return text;
   }

   public void paintComponent(Graphics g)
   {
      super.paintComponent(g);

      JDRGroup paths = app.getImage();

      if (paths == null)
      {
         return;
      }

      Graphics2D g2 = (Graphics2D)g;

      AffineTransform oldAf = g2.getTransform();
      Stroke oldStroke = g2.getStroke();

      double scale = app.getCurrentMagnification();

      g2.scale(scale,scale);

      g2.setPaint(Color.white);
      JDRPaper paper = app.getPaper();

      g2.fill(new Rectangle2D.Double(
         0, 0, paper.getWidth(), paper.getHeight()));

      RenderingHints oldHints = g2.getRenderingHints();
      g2.setRenderingHints(app.getRenderingHints());

      g2.setPaint(Color.lightGray);

      if (paths.flowframe != null)
      {
         paths.flowframe.draw(g,
            new BBox(0,0,app.getPaperWidth(),
                         app.getPaperHeight()));
      }

      for (int i = 0, n=paths.size(); i < n; i++)
      {
          JDRObject object = paths.get(i);

          //object.draw(g,false,false,this);
          object.draw(g,false,this);
      }

      g2.setRenderingHints(oldHints);

      g2.setTransform(oldAf);
   }

   private JDRView app;
}
