// File          : NonNegativeDoubleField.java
// Description   : Provide text fields that only allow non-negative doubles
// Date          : 6th February 2006
// Last Modified : 6th July 2009
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources.numfield;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
 * Text field that only allows non-negative double precision numbers.
 * @author Nicola L C Talbot
 */
public class NonNegativeDoubleField extends JTextField
{
   public NonNegativeDoubleField(double defval)
   {
      super(""+defval, 3);
      setHorizontalAlignment(JTextField.RIGHT);
   }

   protected Document createDefaultModel()
   {
      return new NonNegativeDoubleDocument();
   }

   public void setValue(double val)
   {
      super.setText(""+val);
   }

   public double getValue()
   {
      try
      {
         double n = Double.parseDouble(getText());
         if (n >= 0) return n;
         return 0;
      }
      catch (NumberFormatException e)
      {
         return 0.0;
      }
      catch (NullPointerException e)
      {
         return 0.0;
      }
   }
}

