// File          : HexField.java
// Description   : Provide text fields that only allows positive
//                 hexadecimal numbers
// Date          : 6th February 2006
// Last Modified : 6th July 2009
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources.numfield;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
 * Text field that only allows positive hexadecimal numbers.
 * @author Nicola L C Talbot
 */
public class HexField extends JTextField
{
   public HexField(int defval)
   {
      super(""+defval, 4);
      setHorizontalAlignment(JTextField.RIGHT);
   }

   protected Document createDefaultModel()
   {
      return new HexDocument();
   }

   public void setValue(int val)
   {
      super.setText(""+val);
   }

   public int getValue()
   {
      try
      {
         int i = Integer.parseInt(getText(), 16);
         if (i >= 0) return i;
         return 0;
      }
      catch (NumberFormatException e)
      {
         return 0;
      }
      catch (NullPointerException e)
      {
         return 0;
      }
   }
}

