// File          : BitmapFileFilter.java
// Date          : 1st February 2006
// Last Modified : 24th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources.filter;

import java.io.*;

import uk.ac.uea.cmp.nlct.jdr.io.*;

/**
 * Filter for raster image files. Recognised image extensions:
 * tiff, tif, gif, jpeg, jpg, png.
 */
public class BitmapFileFilter extends javax.swing.filechooser.FileFilter
implements JDRFileFilterInterface
{
   /**
    * Creates a bitmap file filter with default description.
    * The default description is "Image Files".
    */
   public BitmapFileFilter()
   {
      this("Image Files");
   }

   /**
    * Creates a bitmap file filter with given description.
    */
   public BitmapFileFilter(String description)
   {
      super();

      description_ = description;
   }

   /**
    * Determines whether given file is accepted by this filter.
    */
   public boolean accept(File f)
   {
      if (f.isDirectory()) return true;

      String name = f.getName().toLowerCase();

      if (name.endsWith("tiff") ||
          name.endsWith("tif") ||
          name.endsWith("gif") ||
          name.endsWith("jpeg") ||
          name.endsWith("jpg") ||
          name.endsWith("png"))
      {
         return true;
      }
      
      return false;
   }

   /**
    * Gets the description of this filter.
    */
   public String getDescription()
   {
      return description_;
   }

   public String getDefaultExtension()
   {
      return "png";
   }

   public void setVersion(float versionNumber)
   {
      version = versionNumber;
   }

   public float getVersion()
   {
      return version;
   }

   private float version = 1.0f;

   private String description_;
}
