// File          : ZoomSettings.java
// Description   : Provides magnification dialog
// Date          : 1st February 2006
// Last Modified : 9th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import uk.ac.uea.cmp.nlct.jdrresources.numfield.*;

/**
 * Magnification dialog box.
 * @author Nicola L C Talbot
 */

public class ZoomSettings extends JDialog
   implements ActionListener
{
   public ZoomSettings(JDRApp application, Frame parent)
   {
      super(parent, JDRResources.getString("zoom.title"),true);
      setSize(300,100);
      setLocationRelativeTo(parent);
      application_ = application;

      JPanel p1 = new JPanel();

      JLabel label = new JLabel(
         JDRResources.getString("zoom.magnification"));
      label.setDisplayedMnemonic(
         JDRResources.getChar("zoom.magnification.mnemonic"));

      p1.add(label);

      magBox = new NonNegativeDoubleField(100);
      label.setLabelFor(magBox);

      p1.add(magBox);

      getContentPane().add(p1, "Center");

      JPanel p2 = new JPanel();

      p2.add(JDRResources.createOkayButton(this));
      p2.add(JDRResources.createCancelButton(this));
      p2.add(JDRResources.createHelpButton("sec:zoom"));

      getContentPane().add(p2, "South");

      addWindowListener(new WindowAdapter()
         {
            public void windowActivated(WindowEvent e)
            {
               magBox.requestFocusInWindow();
            }
         });
   }

   public void display()
   {
      setMag(application_.getCurrentMagnification());
      setVisible(true);
   }

   public void okay()
   {
      application_.setCurrentMagnification(getMag());
      setVisible(false);
   }

   public void setMag(double mag)
   {
      magBox.setValue(mag);
      magBox.setCaretPosition(0);
   }

   public double getMag()
   {
      double mag = (double)magBox.getValue();

      if (mag == 0.0) mag = 1.0;

      return mag;
   }

   public void actionPerformed(ActionEvent e)
   {
      String action = e.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         okay();
      } 
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   private JDRApp application_;
   private NonNegativeDoubleField magBox;
}
