// File        : JDRToggleButtonItem.java
// Description : Toolbar buttons and menu item
// Date        : 19th May 2011
// Author      : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

import javax.swing.*;

/**
 * Application button and menu item.
 * @author Nicola L C Talbot
 */
public class JDRToggleButtonItem implements ActionListener
{
   public JDRToggleButtonItem(String menuID, String name, 
      KeyStroke keyStroke, ActionListener listener,
      String tooltipText, boolean selected,
      JComponent buttonParent, JMenu menu)
   {
      button = JDRResources.createToggleButton(name, this, keyStroke,
         tooltipText);

      button.setAlignmentX(Component.CENTER_ALIGNMENT);
      button.setAlignmentY(Component.CENTER_ALIGNMENT);

      button.setSelected(selected);

      buttonParent.add(button);

      item = JDRResources.createToggleMenuItem(menuID, name, keyStroke,
         this, tooltipText);

      menu.add(item);

      selected = false;

      mainListener = listener;
   }

   public JDRToggleButtonItem(String menuID, String name, 
      KeyStroke keyStroke, ActionListener listener,
      String tooltipText, JComponent buttonParent, JMenu menu)
   {
      this(menuID, name, keyStroke, listener, tooltipText,
         false, buttonParent, menu);
   }

   public void actionPerformed(ActionEvent evt)
   {
      Object source = evt.getSource();

      selected = !selected;

      if (button.isSelected() != selected)
      {
         button.setSelected(selected);
      }

      if (item.isSelected() != selected)
      {
         item.setSelected(selected);
      }

      if (mainListener != null)
      {
         mainListener.actionPerformed(evt);
      }
   }

   public void setEnabled(boolean flag)
   {
      button.setEnabled(flag);
      item.setEnabled(flag);
   }

   public boolean isEnabled()
   {
      return item.isEnabled();
   }

   public void setSelected(boolean flag)
   {
      selected = flag;
      button.setSelected(flag);
      item.setSelected(flag);
   }

   public boolean isSelected()
   {
      return selected;
   }

   public JDRToggleButton getButton()
   {
      return button;
   }

   public JCheckBoxMenuItem getItem()
   {
      return item;
   }

   public String getText()
   {
      return item.getText();
   }

   private JDRToggleButton button;
   private JCheckBoxMenuItem item;
   private ActionListener mainListener=null;

   private boolean selected;
}
