// File          : JDRFileChooser.java
// Purpose       : File chooser
// Date          : 4th June 2008
// Last Modified : 4th June 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdrresources;

import java.io.*;
import java.beans.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

import javax.swing.*;
import javax.swing.filechooser.*;
import javax.swing.plaf.basic.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdrresources.filter.*;

/**
 * File chooser modified from the workaround described in
   <a href="http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4678049">Java Bug ID 4678049</a>.
*/
public class JDRFileChooser extends JFileChooser
{
   /**
    * Sets the file filter for this file chooser.
    * @param filter the filter to apply to this file chooser
    */
   public void setFileFilter(javax.swing.filechooser.FileFilter filter)
   {
      super.setFileFilter(filter);
              
      if (!(getUI() instanceof BasicFileChooserUI))
      {
         return;
      }

      final BasicFileChooserUI ui = (BasicFileChooserUI) getUI();
      final String name = ui.getFileName().trim();

      if ((name == null) || (name.length() == 0))
      {
         return;
      }
	
      EventQueue.invokeLater(new Thread()
      {
         public void run()
         {
            String currentName = ui.getFileName();

            if ((currentName == null) || (currentName.length() == 0))
            {
               javax.swing.filechooser.FileFilter filter = getFileFilter();

               int i = name.lastIndexOf('.');

               if (i == -1 || filter.accept(new File(name)))
               {
                  ui.setFileName(name);
               }
               else
               {
                  String base = name.substring(0, i);

                  if (filter instanceof JDRFileFilterInterface)
                  {
                     base = base + "."
                          + ((JDRFileFilterInterface)filter)
                              .getDefaultExtension();
                  }

                  ui.setFileName(base);
               }
            }
         }
      });
   }
}
