// File          : JDRCheckBoxMenuItem.java
// Description   : CheckBoxMenu item that uses JDRButtonModel
// Date          : 2012-03-15
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class JDRCheckBoxMenuItem extends JCheckBoxMenuItem
{
   public JDRCheckBoxMenuItem()
   {
      super();

      setModel(new JDRButtonModel());
   }

   public JDRCheckBoxMenuItem(String text)
   {
      super(text);

      setModel(new JDRButtonModel());
   }

   public JDRCheckBoxMenuItem(String text, boolean checked)
   {
      super(text, checked);

      setModel(new JDRButtonModel());
   }

   public JDRCheckBoxMenuItem(String text, char mnemonic)
   {
      super(text);

      setModel(new JDRButtonModel());

      setMnemonic((int)mnemonic);
   }

   public JDRCheckBoxMenuItem(String text, char mnemonic, boolean checked)
   {
      super(text, checked);

      setModel(new JDRButtonModel());

      setMnemonic((int)mnemonic);
   }

   public void setActionId(int id)
   {
      ButtonModel model = getModel();

      if (model instanceof JDRButtonModel)
      {
         ((JDRButtonModel)model).setActionId(id);
      }
   }

   public int getActionId()
   {
      ButtonModel model = getModel();

      if (model instanceof JDRButtonModel)
      {
         return ((JDRButtonModel)model).getActionId();
      }

      return -1;
   }

   protected void fireActionPerformed(ActionEvent event)
   {
      if (!(event instanceof JDRActionEvent))
      {
         super.fireActionPerformed(event);
         return;
      }

      Object[] listeners = listenerList.getListenerList();

      JDRActionEvent e = null;

      for (int i = listeners.length-2; i >= 0; i -= 2)
      {
         if (listeners[i] == ActionListener.class)
         {
            if (e == null)
            {
               int id = ((JDRActionEvent)event).getActionId();

               if (id == -1)
               {
                  id = getActionId();
               }

               e = new JDRActionEvent(JDRCheckBoxMenuItem.this,
                  ActionEvent.ACTION_PERFORMED,
                  id, event.getWhen(), event.getModifiers());
            }

            ((ActionListener)listeners[i+1]).actionPerformed(e);
         }
      }
   }
}
