// File          : JDRButtonModel.java
// Description   : button model that uses JDRActionEvent
// Date          : 2012-03-15
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.*;
import java.awt.event.*;
import java.util.EventListener.*;
import javax.swing.*;
import javax.swing.event.*;

public class JDRButtonModel extends DefaultButtonModel
{
   public JDRButtonModel()
   {
      super();
   }

   public void setPressed(boolean b)
   {
      if ((isPressed() == b) || !isEnabled())
      {
         return;
      }

      if (b)
      {
         stateMask |= PRESSED;
      }
      else
      {
         stateMask &= ~PRESSED;
      }

      if (!isPressed() && isArmed())
      {
         int modifiers = 0;

         AWTEvent currentEvent = EventQueue.getCurrentEvent();

         if (currentEvent instanceof InputEvent)
         {
            modifiers = ((InputEvent)currentEvent).getModifiers();
         }
         else if (currentEvent instanceof ActionEvent)
         {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
         }

         fireActionPerformed
         (
            new JDRActionEvent(this, ActionEvent.ACTION_PERFORMED,
               getActionId(),
               EventQueue.getMostRecentEventTime(),
               modifiers)
         );
      }

      fireStateChanged();
   }

   public void setActionId(int id)
   {
      actionId = id;
   }

   public int getActionId()
   {
      return actionId;
   }

   private int actionId;
}
