// File        : JDRButtonItem.java
// Description : Toolbar buttons and menu item
// Date        : 19th May 2011
// Author      : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

import javax.swing.*;

/**
 * Application button and menu item.
 * @author Nicola L C Talbot
 */
public class JDRButtonItem 
{
   public JDRButtonItem(String menuID, String name, 
      KeyStroke keyStroke, ActionListener listener,
      String tooltipText, JComponent buttonParent, JMenu menu)
   {
      button = JDRResources.createAppButton(name, listener, keyStroke,
         tooltipText);

      button.setAlignmentX(Component.CENTER_ALIGNMENT);
      button.setAlignmentY(Component.CENTER_ALIGNMENT);

      buttonParent.add(button);

      item = JDRResources.createAppMenuItem(menuID, name, keyStroke,
         listener, tooltipText);

      menu.add(item);
   }

   public void setEnabled(boolean flag)
   {
      button.setEnabled(flag);
      item.setEnabled(flag);
   }

   public boolean isEnabled()
   {
      return item.isEnabled();
   }

   public void setSelected(boolean flag)
   {
      button.setSelected(flag);
      item.setSelected(flag);
   }

   public boolean isSelected()
   {
      return item.isSelected();
   }

   public JDRButton getButton()
   {
      return button;
   }

   public JMenuItem getItem()
   {
      return item;
   }

   public int getButtonWidth()
   {
      return button.getWidth();
   }

   public int getButtonHeight()
   {
      return button.getHeight();
   }

   public int getButtonPreferredWidth()
   {
      return button.getPreferredSize().width;
   }

   public int getButtonPreferredHeight()
   {
      return button.getPreferredSize().height;
   }

   public String getText()
   {
      return item.getText();
   }

   private JDRButton button;
   private JMenuItem item;
}
