// File          : JDRActionEvent.java
// Description   : Action that has an integer command
// Date          : 2012-03-15
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.event.ActionEvent;

public class JDRActionEvent extends ActionEvent
{
   public JDRActionEvent(Object source, int id, int command)
   {
      super(source, id, ""+command);

      commandId = command;
   }

   public JDRActionEvent(Object source, int id, int command, int modifiers)
   {
      super(source, id, ""+command, modifiers);

      commandId = command;
   }

   public JDRActionEvent(Object source, int id, int command, long when, int modifiers)
   {
      super(source, id, ""+command, when, modifiers);

      commandId = command;
   }

   public int getActionId()
   {
      return commandId;
   }

   private int commandId;
}
