// File          : EPSSquareRight.java
// Purpose       : class representing ] operator
// Date          : 1st June 2008
// Last Modified : 1st June 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.io.*;
import java.awt.geom.*;
import java.util.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.eps.*;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;

/**
 * Object representing ] operator.
 * @author Nicola L C Talbot
 */
public class EPSSquareRight extends EPSOperator
{
   public EPSSquareRight()
   {
      super("]");
   }

   public void execute(EPSStack stack, EPS eps)
      throws InvalidFormatException,
             NoninvertibleTransformException,
             IOException
   {
      int n = 0;

      EPSObject object = stack.popObject();
      Vector<EPSObject> vector = new Vector<EPSObject>();

      while (!(object instanceof EPSMark))
      {
         vector.add(object);
         object = stack.popObject();
         n++;
      }

      EPSArray array = new EPSArray(n);

      for (int i = 0; i < vector.size(); i++)
      {
         array.set(--n, vector.get(i));
      }

      stack.add(array);
   }


}
