// File          : EPSReadHexString.java
// Purpose       : class representing readhexstring operator
// Date          : 1st June 2008
// Last Modified : 1st June 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.io.*;
import java.awt.geom.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.eps.*;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;

/**
 * Object representing readhexstring operator.
 * @author Nicola L C Talbot
 */
public class EPSReadHexString extends EPSOperator
{
   public EPSReadHexString()
   {
      super("readhexstring");
   }

   public void execute(EPSStack stack, EPS eps)
      throws InvalidFormatException,
             NoninvertibleTransformException,
             IOException
   {
      EPSString str = stack.popEPSString();
      EPSFile file = stack.popEPSFile();

      char[] buffer = new char[str.length()];

      int n = file.readhexstring(buffer);

      if (n > 0 && !file.atEOF()) 
      {
         char[] result = new char[n];

         for (int i = 0; i < n; i++)
         {
            result[i] = buffer[i];
         }

         str.putInterval(0, result);

         stack.pushString(new String(result));
         stack.pushBoolean(true);
      }
      else
      {
         stack.pushString(new String());
         stack.pushBoolean(false);
      }
   }

}
