// File          : EPSCvi.java
// Purpose       : class representing cvi operator
// Date          : 1st June 2008
// Last Modified : 1st June 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.io.*;
import java.awt.geom.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.eps.*;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;

/**
 * Object representing cvi operator.
 * @author Nicola L C Talbot
 */
public class EPSCvi extends EPSOperator
{
   public EPSCvi()
   {
      super("cvi");
   }

   public void execute(EPSStack stack, EPS eps)
      throws InvalidFormatException,
             NoninvertibleTransformException,
             IOException
   {
      EPSObject object = stack.popObject();

      if (object instanceof EPSNumber)
      {
         EPSNumber number = (EPSNumber)object;

         if (number instanceof EPSDouble)
         {
            stack.pushInteger(number.intValue());
         }
         else
         {
            stack.add(number);
         }
      }
      else if (object instanceof EPSString)
      {
         try
         {
            String[] split = 
               ((EPSString)object).value().split(" ", 2);
            String str = split[0];
            split = str.split("#", 2);

            if (split.length == 1)
            {
               stack.pushInteger((int)Double.parseDouble(str));
            }
            else
            {
               stack.pushInteger(Integer.parseInt(split[1],
                  Integer.parseInt(split[0])));
            }
         }
         catch (NumberFormatException e)
         {
            throw new InvalidEPSObjectException(
               "(cvi) invalid string", eps.getLineNum());
         }
      }
      else
      {
         throw new InvalidEPSObjectException("(cvi) invalid type",
            eps.getLineNum());
      }
   }
}
