// File          : EPSCurveTo.java
// Purpose       : class representing curveto operator
// Date          : 1st June 2008
// Last Modified : 1st June 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.io.*;
import java.awt.geom.*;

import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.eps.*;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;

/**
 * Object representing curveto operator.
 * @author Nicola L C Talbot
 */
public class EPSCurveTo extends EPSOperator
{
   public EPSCurveTo()
   {
      super("curveto");
   }

   public void execute(EPSStack stack, EPS eps)
      throws InvalidFormatException,
             NoninvertibleTransformException,
             IOException
   {
      double y3 = stack.popDouble();
      double x3 = stack.popDouble();
      double y2 = stack.popDouble();
      double x2 = stack.popDouble();
      double y1 = stack.popDouble();
      double x1 = stack.popDouble();

      eps.getCurrentGraphicsState().curveTo((float)x1, (float)y1,
         (float)x2, (float)y2, (float)x3, (float)y3);
   }
}
