// File          : SVG.java
// Purpose       : functions to save JDRGroup as SVG file
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr.io;

import java.io.*;
import java.awt.geom.*;
import java.util.Enumeration;

import uk.ac.uea.cmp.nlct.jdr.*;

/**
 * Contains single method to write image to SVG file. This needs
 * more work as I haven't been able to test it for a while.
 * @author Nicola L C Talbot
 */

public class SVG
{
   /**
    * Saves image to SVG file.
    * @param image image to save
    * @param title image title
    * @param out output stream
    * @throws IOException if I/O error occurs
    */
   public static void save(JDRGroup image, String title, PrintWriter out)
      throws IOException
   {
      BBox box = image.getBBox();
      // convert from left to right handed co-ordinates and
      // shift up
      double width = box.getWidth();
      double height = box.getHeight();
      out.println("<?xml version=\"1.0\" standalone=\"no\"?>");
      out.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"");
      out.println("         \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
      out.println("<svg width=\""+width+"\" height=\""
         + height + "\"");
      out.println("     viewBox=\""
         + box.getMinX() + " " + box.getMinY() + " "
         + box.getMaxX() + " " + box.getMaxY()+"\"");
      out.println("     transform=\"scale(1.25,1.25)\"");
      out.println("     version=\"1.1\"");
      out.println("     xmlns=\"http://www.w3.org/2000/svg\"");
      out.println("     xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
      out.println("   <title>"+title+"</title>");
      if (!image.description.equals(""))
      {
         out.println("   <desc>"+image.description+"</desc>");
      }
      out.println("   <defs>");
      JDRBasicStroke.svgDefs(out, image);
      JDRGradient.svgDefs(out, image);
      JDRRadial.svgDefs(out, image);
      out.println("   </defs>");
      for (int i = 0; i < image.size(); i++)
      {
         image.get(i).saveSVG(out);
      }
      out.println("</svg>");
   }

   public static void savePoint(PrintWriter out, double x, double y)
   {
      out.print(""+x+" "+y+" ");
   }

   public static void savePoint(PrintWriter out, Point2D p)
   {
      out.print(""+p.getX()+" "+p.getY()+" ");
   }
}
