// File          : PNG.java
// Purpose       : functions to save JDRGroup as PNG file
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr.io;

import java.io.*;
import java.util.Enumeration;
import java.awt.*;
import java.awt.image.*;
import javax.imageio.*;

import uk.ac.uea.cmp.nlct.jdr.*;

/**
 * Functions to save image in PNG format. Note that this writes the
 * image as a bitmap rather not in vector format so enlarging the PNG
 * image will degrade the quality.
 * @author Nicola L C Talbot
 */

public class PNG
{
   /**
    * Saves image in PNG format.
    * @param group image
    * @param filename name of file to write
    * @throws IOException if I/O exception occurs
    */
   public static void save(JDRGroup group, String filename)
      throws IOException
   {
      save(group, new File(filename));
   }

   /**
    * Saves image in PNG format.
    * @param group image
    * @param file output file
    * @throws IOException if I/O exception occurs
    */
   public static void save(JDRGroup group, File file)
      throws IOException
   {
      double norm = JDRUnit.getNormalizingFactor();

      int width = (int)Math.ceil(norm*(group.getBBox().getWidth()+1));
      int height = (int)Math.ceil(norm*(group.getBBox().getHeight()+1));

      BufferedImage buffImage = new BufferedImage(width, height,
         BufferedImage.TYPE_INT_RGB);

      Graphics2D g2 = buffImage.createGraphics();

      RenderingHints renderHints =
            new RenderingHints(RenderingHints.KEY_ANTIALIASING,
                               RenderingHints.VALUE_ANTIALIAS_ON);

      renderHints.add(new RenderingHints(
                          RenderingHints.KEY_RENDERING,
                          RenderingHints.VALUE_RENDER_QUALITY));

      g2.setRenderingHints(renderHints);

      g2.setColor(Color.white);
      g2.fillRect(0,0,width,height);

      g2.scale(norm, norm);
      g2.translate(-group.getBBox().getMinX(), -group.getBBox().getMinY());

      for (int i = 0; i < group.size(); i++)
      {
          group.get(i).draw(g2,false,null);
      }

      g2.dispose();

      ImageIO.write(buffImage, "png", file);
   }
}
