// File          : JDRTransparentListener.java
// Date          : 29th February 2008
// Last Modified : 29th February 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.util.*;

import uk.ac.uea.cmp.nlct.jdr.io.*;

/**
 * Loader listener for transparent paint.
 * @author Nicola L C Talbot
 */

public class JDRTransparentListener implements JDRPaintLoaderListener
{
   public char getJDRid(float version)
   {
      return 'T';
   }

   public void writeJDR(JDRPaint paint,
                    DataOutputStream dout,
                    float version)
   throws IOException
   {
   }

   public JDRPaint readJDR(DataInputStream din, float version)
   throws IOException,InvalidFormatException
   {
      return JDRTransparent.Transparent;
   }

   public char getAJRid(float version)
   {
      return 'T';
   }

   public void writeAJR(JDRPaint paint,
                    PrintWriter out,
                    float version)
   throws IOException
   {
   }

   public JDRPaint readAJR(BufferedReader in, float version)
   throws IOException,InvalidFormatException,
          java.nio.BufferOverflowException,
          EOFException
   {
      return new JDRTransparent();
   }

   public int getConfigId()
   {
      return 0;
   }

   public String getConfigString(JDRPaint paint)
   {
      return "";
   }

   public JDRPaint parseConfig(String paintSpecs)
   throws InvalidFormatException
   {
      remainder = paintSpecs;

      return JDRTransparent.Transparent;
   }

   /**
    * Gets the remainder of the specs String after it has been
    * parsed by {@link #parseConfig(String)}.
    */
   public String getConfigRemainder()
   {
      return remainder;
   }

   private String remainder="";
}
