// File          : JDRTransparent.java
// Date          : 1st February 2006
// Last Modified : 13th January 2007
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.awt.*;
import java.awt.geom.*;

/**
 * Class representing completely transparent colour (i.e no colour).
 * This is used to indicate that something shouldn't be drawn
 * or filled. For example, a fill colour of this type indicates
 * that the path shouldn't be filled (but may be stroked) and a 
 * line colour of this type indicates that the line shouldn't be 
 * stroked (but may be filled). A marker fill colour of this type
 * indicates that the marker should use the same colour as the path
 * to which it is attached.
 * @author Nicola L C Talbot
 */
public class JDRTransparent implements JDRPaint,Serializable
{
   public Color getColor()
   {
      return colour;
   }

   public JDRColor getJDRColor()
   {
      JDRColor c = null;

      try
      {
         c = new JDRColor(0,0,0,0);
      }
      catch (InvalidFormatException ignore)
      {
      }

      return c;
   }

   public JDRColorHSB getJDRColorHSB()
   {
      try
      {
         return new JDRColorHSB(0,0,0,0);
      }
      catch (InvalidFormatException e)
      {
         // this shouldn't happen
      }

      return new JDRColorHSB();
   }

   public JDRColorCMYK getJDRColorCMYK()
   {
      try
      {
         return new JDRColorCMYK(0,0,0,0,0);
      }
      catch (InvalidFormatException e)
      {
         // this shouldn't happen
      }

      return new JDRColorCMYK();
   }

   public JDRGray getJDRGray()
   {
      try
      {
         return new JDRGray(0,0);
      }
      catch (InvalidFormatException e)
      {
         // this shouldn't happen
      }

      return new JDRGray();
   }

   public Paint getPaint(BBox box)
   {
      return colour;
   }

   public String getID()
   {
      return "0.0.0.0";
   }

   public String pgf(BBox box) {return "";}

   public String pgffillcolor(BBox box) {return "";}

   public String pgfstrokecolor(BBox box) {return "";}

   public void saveEPS(PrintWriter out, BBox box)
      throws IOException
   {
   }

   public int psLevel()
   {
      return 1;
   }

   public double getAlpha()
   {
      return 0.0;
   }

   public String svg()
   {
      return "none";
   }

   public String svgFill()
   {
      return "fill=\"none\"";
   }

   public String svgLine()
   {
      return "stroke=\"none\"";
   }

   public Object clone()
   {
      return new JDRTransparent();
   }

   public String toString()
   {
      return new String("JDRTransparent");
   }

   public JDRPaintLoaderListener getListener()
   {
      return listener;
   }

   public void fade(double value)
   {
   }

   private static Color colour = new Color(0, 0, 0, 0);

   public static final JDRTransparent Transparent = new JDRTransparent();

   private static JDRTransparentListener listener = new JDRTransparentListener();
}
