// File          : JDRStroke.java
// Date          : 7th July 2009
// Last Modified : 29th August 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.awt.*;
import java.awt.geom.*;

/**
 * Stroke interface.
 * @author Nicola L C Talbot
 */

public interface JDRStroke extends Stroke,Cloneable,Serializable
{
   /**
    * Gets a copy of this stroke.
    */
   public Object clone();

   /**
    * Gets the winding rule.
    * @return the winding rule
    */
   public int getWindingRule();

   /**
    * Sets the winding rule.
    * @param rule the winding rule
    * @throws InvalidWindingRuleException
    */
   public void setWindingRule(int rule)
      throws InvalidWindingRuleException;

   /**
    * Draws the given path using this stroke.
    * @param path the path to draw
    * @param g the graphics device
    */
   public void drawPath(JDRShape path, Graphics g);

   public void drawPath(JDRShape shape, GeneralPath generalPath, Graphics g);

   /**
    * Gets the stroked outline for the given path including
    * any markers.
    * @param path the path to which this stroke applies
    * @return the path outlining this stroked shape
    * @see #getStrokedArea(JDRShape)
    */
   public Shape getStrokedPath(JDRShape path);

   /**
    * Gets the outline for the given path including any markers.
    * @param path the path to which this stroke applies
    * @return the path outlining the stroked shape including
    * any markers
    * @see #getStrokedPath(JDRShape)
    */
   public Area getStrokedArea(JDRShape path);

   /**
    * Saves this stroke in the given version of JDR format.
    * @param dout the output stream
    * @param version the JDR version
    * @throws IOException if I/O error occurs
    * @see #saveAJR(PrintWriter,float)
    */
   public void save(DataOutputStream dout, float version)
      throws IOException;

   /**
    * Saves this stroke in the given version of AJR format.
    * @param out the output stream
    * @param version the AJR version
    * @throws IOException if I/O error occurs
    * @see #save(DataOutputStream,float)
    */
   public void saveAJR(PrintWriter out, float version)
      throws IOException, InvalidFormatException;

   public void saveEPS(JDRShape path, PrintWriter out)
      throws IOException;

   /**
    * Gets the path style listener for the shape associated with
    * this stroke.
    * @return the path style listener for the shape associated with
    * this stroke
    */
   public JDRPathStyleListener getPathStyleListener();

   public String info();
}
