// File          : JDRPatternAnchorPoint.java
// Date          : 8th April 2011
// Last Modified : 8th April 2011
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;

import uk.ac.uea.cmp.nlct.jdr.io.*;

/**
 * Class representing a pattern anchor control point.
 * @author Nicola L C Talbot
 */
public class JDRPatternAnchorPoint extends JDRPoint
{
   /**
    * Creates a new control point at the origin.
    */
   public JDRPatternAnchorPoint()
   {
      super();
   }

   /**
    * Creates a control point at the given location.
    * @param p the location of the new point
    */
   public JDRPatternAnchorPoint(Point p)
   {
      super(p);
   }

   /**
    * Creates a control point at the given location.
    * @param p the location of the new point
    */
   public JDRPatternAnchorPoint(Point2D p)
   {
      super(p);
   }

   /**
    * Creates a control point at the given location.
    * @param px the x co-ordinate
    * @param py the y co-ordinate
    */
   public JDRPatternAnchorPoint(double px, double py)
   {
      super(px, py);
   }

   public Paint getSelectedPaint()
   {
      return patternAnchorSelectColor;
   }

   public void setSelectedPaint(Paint paint)
   {
      patternAnchorSelectColor = paint;
   }

   public Paint getUnselectedPaint()
   {
      return patternAnchorColor;
   }

   public void setUnselectedPaint(Paint paint)
   {
      patternAnchorColor = paint;
   }

   public Object clone()
   {
      JDRPatternAnchorPoint p = new JDRPatternAnchorPoint(x,y);
      p.makeEqual(this);
      return p;
   }

   /**
    * Gets string representation of this point.
    * @return string representation of this point
    */
   public String toString()
   {
      return new String("JDRPatternAnchorPoint("+x+","+y+")");
   }

   public static Paint patternAnchorColor = new Color(51,255,51,200);
   public static Paint patternAnchorSelectColor = new Color(0,100,0,200);
}
