// File          : JDRPathSegment.java
// Date          : 26th July 2010
// Last Modified : 18th August 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import uk.ac.uea.cmp.nlct.jdr.marker.*;

/**
 * Path segment interface.
 * @author Nicola L C Talbot
 */

public interface JDRPathSegment extends Cloneable,Serializable
{
   /**
    * Gets a copy of this segment.
    */
   public Object clone();

   public String pgf(AffineTransform af);

   public void translate(double x, double y);

   public void rotate(Point2D p, double angle);

   public void scale(Point2D p, double sx, double sy);

   public void shear(Point2D p, double sx, double sy);

   public void transform(double[] matrix);

   public double getStartX();

   public double getStartY();

   public double getEndX();

   public double getEndY();

   public JDRPoint getStart();

   public JDRPoint getEnd();

   public void setStart(JDRPoint p);

   public void setStart(Point2D p);

   public void setEnd(JDRPoint p);

   public JDRPathSegment getReflection(JDRLine line);

   public JDRPathSegment reverse();

   public void setEditedControls(boolean flag);

   public void setSelected(boolean flag);

   public boolean isSelected();

   public JDRPathSegment convertToLine();
   public JDRPathSegment convertToSegment();
   public JDRPathSegment convertToBezier();

   public BBox getControlBBox();

   public void mergeControlBBox(BBox box);

   public void appendToGeneralPath(GeneralPath path);

   public void draw(Graphics g, double scale);

   public void drawSelectedNoControls(Graphics g, double scale);

   public void drawControls(Graphics g, boolean endPoint, double scale);

   /**
    * Splits this segment in half. Returns the other half.
    * @return the end half of this segment before it was split
    */
   public JDRPathSegment split();

   /**
    * Draws this segment in draft mode.
    * @param g the graphics device on which to draw
    * @param scale the scaling factor
    * @param drawEnd flag indicating whether to draw the end point
    */
   public void drawDraft(Graphics g, double scale, boolean drawEnd);

   public void saveSVG(PrintWriter out) throws IOException;

   public void saveEPS(PrintWriter out) throws IOException;

   public Point2D getP(double t);

   /**
    * Gets the gradient vector for the line between the start and
    * end points of this segment.
    * @return gradient vector
    */
   public Point2D getdP();

   /**
    * Gets the gradient vector for this segment at t.
    * @param t the parameter used to describe this segment
    * @return gradient vector
    * @see #getdP0()
    * @see #getdP1()
    */
   public Point2D getdP(double t);

   /**
    * Gets the gradient vector for this segment at t=0.
    * @return gradient vector at t=0
    */
   public Point2D getdP0();

   /**
    * Gets the gradient vector for this segment at t=1.
    * @return gradient vector at t=1
    */
   public Point2D getdP1();

   public JDRMarker getStartMarker();

   public JDRMarker getEndMarker();

   public void setStartMarker(JDRMarker marker);

   public void setEndMarker(JDRMarker marker);

   public int controlCount();

   public JDRPoint getControl(int index) throws IndexOutOfBoundsException;

   public int getControlIndex(JDRPoint point) throws NoSuchElementException;

   public BBox getBBox();

   /**
    * Returns true if this represents a gap in the shape.
    */
   public boolean isGap();
}
