// File          : JDRGroupListener.java
// Date          : 29th February 2008
// Last Modified : 29th February 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.util.*;

import uk.ac.uea.cmp.nlct.jdr.io.*;

/**
 * Loader listener for paths.
 * @author Nicola L C Talbot
 */

public class JDRGroupListener implements JDRObjectLoaderListener
{
   public char getJDRid(float version)
   {
      return 'G';
   }

   public void writeJDR(JDRObject object,
                    DataOutputStream dout,
                    float version)
   throws IOException,InvalidFormatException
   {
      JDRGroup group = (JDRGroup)object;

      JDRObjectLoader objectLoader = JDR.getObjectLoader();

      int n = group.size();
      dout.writeInt(n);

      int progress = JDR.messageSystem.getProgress();

      JDR.messageSystem.resetProgress(n);

      for (int i = 0; i < n; i++)
      {
         objectLoader.saveJDR(group.get(i), dout, version);

         JDR.messageSystem.incrementProgress();
      }

      JDR.messageSystem.setProgress(progress);
   }

   public JDRObject readJDR(DataInputStream din, float version)
   throws IOException,InvalidFormatException
   {
      int n = din.readInt();

      int progress = JDR.messageSystem.getProgress();

      JDR.messageSystem.resetProgress(n);

      JDRGroup group = new JDRGroup(n);

      JDRObjectLoader objectLoader = JDR.getObjectLoader();

      for (int i = 0; i < n; i++)
      {
         JDRCompleteObject object 
            = (JDRCompleteObject)objectLoader.loadJDR(din, version);

         if (object != null) group.add(object);

         JDR.messageSystem.incrementProgress();
      }

      JDR.messageSystem.setProgress(progress);

      return group;
   }

   public char getAJRid(float version)
   {
      return 'G';
   }

   public void writeAJR(JDRObject object,
                        PrintWriter out,
                        float version)
   throws IOException,InvalidFormatException
   {
      JDRGroup group = (JDRGroup)object;

      JDRObjectLoader objectLoader = AJR.getObjectLoader();

      int n = group.size();
      AJR.writeInt(out, n);

      int progress = JDR.messageSystem.getProgress();

      JDR.messageSystem.resetProgress(n);

      for (int i = 0; i < n; i++)
      {
         objectLoader.saveAJR(group.get(i), out, version);

         JDR.messageSystem.incrementProgress();
      }

      JDR.messageSystem.setProgress(progress);
   }

   public JDRObject readAJR(BufferedReader in, float version)
   throws IOException,InvalidFormatException,
          java.nio.BufferOverflowException,
          EOFException
   {
      int n = AJR.readInt(in);

      int progress = JDR.messageSystem.getProgress();

      JDR.messageSystem.resetProgress(n);

      JDRGroup group = new JDRGroup(n);

      JDRObjectLoader objectLoader = AJR.getObjectLoader();

      for (int i = 0; i < n; i++)
      {
         JDRCompleteObject object 
            = (JDRCompleteObject)objectLoader.loadAJR(in, version);

         group.add(object);

         JDR.messageSystem.incrementProgress();
      }

      JDR.messageSystem.setProgress(progress);

      return group;
   }

}
