// File          : JDRBasicPathStyleListener.java
// Date          : 29th August 2010
// Last Modified : 29th August 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.util.*;

import uk.ac.uea.cmp.nlct.jdr.io.*;

/**
 * Basic path style listener.
 * @author Nicola L C Talbot
 * @see JDRPathStyleLoader
 */

public class JDRBasicPathStyleListener implements JDRPathStyleListener
{
   public byte getJDRid(float version)
   {
      return (byte)0;
   }

   public void writeJDR(JDRShape shape,
                    DataOutputStream dout,
                    float version)
   throws IOException
   {
      JDRPaintLoader paintLoader = JDR.getPaintLoader();

      paintLoader.saveJDR(shape.getLinePaint(), dout, version);
      paintLoader.saveJDR(shape.getFillPaint(), dout, version);
      shape.getStroke().save(dout, version);
   }

   public void readJDR(DataInputStream din, float version, JDRShape shape)
   throws IOException,InvalidFormatException
   {
      JDRPaintLoader paintLoader = JDR.getPaintLoader();

      shape.setLinePaint(paintLoader.loadJDR(din, version));
      shape.setFillPaint(paintLoader.loadJDR(din, version));
      shape.setStroke(JDRBasicStroke.read(din, version));
   }

   public int getAJRid(float version)
   {
      return 0;
   }

   public void writeAJR(JDRShape shape,
                    PrintWriter out,
                    float version)
   throws IOException,InvalidFormatException
   {
      JDRPaintLoader paintLoader = AJR.getPaintLoader();

      paintLoader.saveAJR(shape.getLinePaint(), out, version);
      paintLoader.saveAJR(shape.getFillPaint(), out, version);
      shape.getStroke().saveAJR(out, version);
   }

   public void readAJR(BufferedReader in, float version, JDRShape shape)
   throws IOException,InvalidFormatException,
          java.nio.BufferOverflowException,
          EOFException
   {
      JDRPaintLoader paintLoader = AJR.getPaintLoader();

      shape.setLinePaint(paintLoader.loadAJR(in, version));
      shape.setFillPaint(paintLoader.loadAJR(in, version));
      shape.setStroke(JDRBasicStroke.readAJR(in, version));
   }

}
