// File          : InvalidToolException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.id.tool

/**
 * Exception thrown when an invalid tool is requested.
 * @author Nicola L C Talbot
 */
public class InvalidToolException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid tool ID.
    * @param tool invalid ID
    */
   public InvalidToolException(int tool)
   {
      super("Invalid tool "+tool);
      invalidTool = ""+tool;
   }

   /**
    * Initialises indicating the invalid tool identifier.
    * @param identifier invalid identifier
    */
   public InvalidToolException(String identifier)
   {
      super("Invalid tool identifier '"+identifier+"'");
      invalidTool = identifier;
   }

   /**
    * Initialises indicating the invalid ID and line number where the
    * error occurred.
    * @param tool invalid ID
    * @param line line number
    */
   public InvalidToolException(int tool, int line)
   {
      super("Invalid tool "+tool+" on line "+line);
      invalidTool = ""+tool;
      lineNum = line;
   }

   /**
    * Gets the invalid identifier.
    * @return invalid identifier
    */
   public String getInvalidTool()
   {
      return invalidTool;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private String invalidTool;
   private int lineNum=-1;
}
