// File          : InvalidSettingsIDException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.id.settings

/**
 * Exception thrown when an invalid ID is used to identify
 * the settings.
 * @author Nicola L C Talbot
 */
public class InvalidSettingsIDException extends InvalidFormatException
{
   /**
    * Initialises with the invalid ID.
    * @param id invalid ID
    */
   public InvalidSettingsIDException(int id)
   {
      super("Invalid settings ID "+id);
      invalidID = id;
   }

   /**
    * Initialises with the invalid ID and line number on which the
    * error occurs.
    * @param id invalid ID
    * @param line line number
    */
   public InvalidSettingsIDException(int id, int line)
   {
      super("Invalid settings ID "+id+" on line "+line);
      invalidID = id;
      lineNum = line;
   }

   /**
    * Gets the invalid ID.
    * @return invalid ID
    */
   public int getInvalidID()
   {
      return invalidID;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private int invalidID;
   private int lineNum=-1;
}
