// File          : InvalidReplicaException.java
// Date          : 9th Sept 2010
// Last Modified : 9th Sept 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_replicas
/**
 * Exception thrown when an invalid replica number is used.
 * @author Nicola L C Talbot
 */
public class InvalidReplicaException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid number.
    * @param invalidNum invalid number
    */
   public InvalidReplicaException(int invalidNum)
   {
      super("Invalid replica value "+invalidNum);
      invalidNum_ = invalidNum;
   }

   /**
    * Initialises indicating the invalid number and the line number
    * where the error occurred.
    * @param invalidNum invalid replica number
    * @param line line number
    */
   public InvalidReplicaException(int invalidNum, int line)
   {
      super("Invalid replica value "+invalidNum+" on line "+line);
      invalidNum_ = invalidNum;
      lineNum = line;
   }

   /**
    * Gets the invalid replica number.
    * @return invalid replica number
    */
   public int getInvalidValue()
   {
      return invalidNum_;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private int invalidNum_;
   private int lineNum=-1;
}
