// File          : InvalidPenWidthException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_penwidth
/**
 * Exception thrown when an invalid pen width is requested.
 * @author Nicola L C Talbot
 */
public class InvalidPenWidthException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid pen width.
    * @param width invalid pen width
    */
   public InvalidPenWidthException(double width)
   {
      super("Invalid pen width "+width);
      penWidth=width;
   }

   /**
    * Initialises indicating the invalid pen width and line number where the
    * error occurred.
    * @param width invalid pen width
    * @param line line number
    */
   public InvalidPenWidthException(double width, int line)
   {
      super("Invalid pen width "+width+" on line "+line);
      penWidth=width;
      lineNum = line;
   }

   /**
    * Gets the invalid pen width.
    * @return invalid pen width
    */
   public double getInvalidWidth()
   {
      return penWidth;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private double penWidth;
   private int lineNum=-1;
}
