// File          : InvalidPaperNameException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.id.paper

/**
 * Exception thrown when an unknown paper name is used.
 * @author Nicola L C Talbot
 */
public class InvalidPaperNameException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid name.
    * @param idname invalid name
    */
   public InvalidPaperNameException(String idname)
   {
      super("Invalid paper name "+idname);
      invalidName = idname;
   }

   /**
    * Initialises indicating the invalid name and line number where the
    * error occurred.
    * @param idname invalid name
    * @param line line number
    */
   public InvalidPaperNameException(String idname, int line)
   {
      super("Invalid paper name "+idname+" on line "+line);
      invalidName = idname;
      lineNum = line;
   }

   /**
    * Gets the invalid name.
    * @return invalid name
    */
   public String getInvalidName()
   {
      return invalidName;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private String invalidName;
   private int lineNum=-1;
}
