// File          : InvalidMitreLimitException.java
// Date          : 13th June 2007
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_mitre_limit
/**
 * Exception thrown when an invalid mitre limit is requested.
 * @author Nicola L C Talbot
 */
public class InvalidMitreLimitException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid value.
    * @param invalidValue invalid value
    */
   public InvalidMitreLimitException(double invalidValue)
   {
      super("Invalid mitre limit "+invalidValue);
      invalidValue_ = invalidValue;
   }

   /**
    * Initialises indicating the invalid value and line number where the
    * error occurred.
    * @param invalidValue invalid value
    * @param line line number
    */
   public InvalidMitreLimitException(double invalidValue, int line)
   {
      super("Invalid mitre limit "+invalidValue+" on line "+line);
      invalidValue_ = invalidValue;
      lineNum = line;
   }

   /**
    * Gets the invalid value.
    * @return invalid value
    */
   public double getInvalidValue()
   {
      return invalidValue_;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private double invalidValue_;
   private int lineNum=-1;
}
