// File          : InvalidImageFormatException.java
// Date          : 12th June 2008
// Last Modified : 12th June 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_linkname
/**
 * Exception thrown when a image's format is unrecognised.
 * @author Nicola L C Talbot
 */
public class InvalidImageFormatException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid image.
    * @param filename invalid image's filename
    */
   public InvalidImageFormatException(String filename)
   {
      super("Invalid image format for '"+filename+"'");
      invalidFilename = filename;
   }

   /**
    * Initialises indicating the invalid image and the line number
    * where the error occurred.
    * @param filename invalid image's filename
    * @param line line number
    */
   public InvalidImageFormatException(String filename, int line)
   {
      super("Invalid image format for file '"+filename+"' on line "+line);
      invalidFilename = filename;
      lineNum = line;
   }

   /**
    * Gets the invalid filename.
    * @return invalid filename
    */
   public String getInvalidFilename()
   {
      return invalidFilename;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private String invalidFilename;
   private int lineNum=-1;
}
