// File          : InvalidIdlLengthException.java
// Purpose       : Flow frame exception
// Date          : 5th June 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//               http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.jdr;

import java.io.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;

// error.invalid_idl_length
/**
 * Exception thrown when length of IDL string is invalid.
 * @author Nicola L C Talbot
 */
public class InvalidIdlLengthException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid length.
    * @param length invalid IDL length
    */
   public InvalidIdlLengthException(int length)
   {
      super("Invalid IDL length "+length);
      invalidLength = length;
   }

   /**
    * Initialises indicating the invalid length and the line number
    * where the error occurred.
    * @param length invalid IDL length
    * @param line line number
    */
   public InvalidIdlLengthException(int length, int line)
   {
      super("Invalid IDL length "+length+" on line "+line);
      invalidLength = length;
      lineNum = line;
   }

   /**
    * Gets the invalid length.
    * @return invalid IDL length
    */
   public int getInvalidLength()
   {
      return invalidLength;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private int invalidLength;
   private int lineNum=-1;
}

