// File          : InvalidGridException.java
// Date          : 16th August 2010
// Last Modified : 16th August 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

/**
 * Exception thrown when an invalid grid layout is requested.
 * @author Nicola L C Talbot
 */
public class InvalidGridException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid grid ID.
    * @param grid invalid ID
    */
   public InvalidGridException(int grid)
   {
      super("Invalid grid ID "+grid);
      invalidGrid = grid;
   }

   public InvalidGridException(String message)
   {
      super(message);
      invalidGrid = -1;
   }

   public InvalidGridException(String message, int line)
   {
      super(message);
      invalidGrid = -1;
      lineNum = line;
   }

   /**
    * Initialises indicating the invalid ID and line number where the
    * error occurred.
    * @param grid invalid ID
    * @param line line number
    */
   public InvalidGridException(int grid, int line)
   {
      super("Invalid grid ID "+grid+" on line "+line);
      invalidGrid = grid;
      lineNum = line;
   }

   /**
    * Gets the invalid identifier.
    * @return invalid identifier
    */
   public int getInvalidGrid()
   {
      return invalidGrid;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private int invalidGrid;
   private int lineNum=-1;
}
