// File          : InvalidGridArgumentException.java
// Date          : 16th August 2010
// Last Modified : 16th August 2010
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

/**
 * Exception thrown when an invalid argument to grid layout is requested.
 * @author Nicola L C Talbot
 */
public class InvalidGridArgumentException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid grid argument.
    * @param invalidArg invalid argument
    */
   public InvalidGridArgumentException(double invalidArg)
   {
      super("Invalid grid argument "+invalidArg);
      invalidGridArgument = invalidArg;
   }

   /**
    * Initialises indicating the invalid grid argument with custom
    * error message.
    * @param message error message
    * @param invalidArg invalid argument
    */
   public InvalidGridArgumentException(String message, double invalidArg)
   {
      super(message);
      invalidGridArgument = invalidArg;
   }

   /**
    * Initialises indicating the invalid ID and line number where the
    * error occurred.
    * @param invalidArg invalid argument
    * @param line line number
    */
   public InvalidGridArgumentException(double invalidArg, int line)
   {
      super("Invalid grid argument "+invalidArg+" on line "+line);
      invalidGridArgument = invalidArg;
      lineNum = line;
   }

   /**
    * Gets the invalid identifier.
    * @return invalid identifier
    */
   public double getInvalidGridArgument()
   {
      return invalidGridArgument;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private double invalidGridArgument;
   private int lineNum=-1;
}
