// File          : InvalidFontWeightException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_series
/**
 * Exception thrown when an invalid ID is used to identify
 * a font weight.
 * @author Nicola L C Talbot
 */
public class InvalidFontWeightException extends InvalidFormatException
{
   /**
    * Initialises with the invalid ID.
    * @param id invalid ID
    */
   public InvalidFontWeightException(int id)
   {
      super("Invalid font weight "+id);
      invalidID = id;
   }

   /**
    * Initialises with the given message and invalid ID.
    * @param id invalid ID
    */
   public InvalidFontWeightException(String message, int id)
   {
      super(message);
      invalidID = id;
   }

   /**
    * Initialises with the given message and invalid ID and
    * line number.
    * @param message error message
    * @param id invalid ID
    * @param line line number
    */
   public InvalidFontWeightException(String message, int id, int line)
   {
      super(message, line);
      invalidID = id;
   }

   /**
    * Gets the invalid ID.
    * @return invalid ID
    */
   public int getInvalidID()
   {
      return invalidID;
   }

   private int invalidID;
}
