// File          : InvalidFontSizeException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2007
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_size
/**
 * Exception thrown when an invalid font size is given.
 * @author Nicola L C Talbot
 */
public class InvalidFontSizeException extends InvalidFormatException
{
   /**
    * Initialises with the invalid size.
    * @param invalidSize invalid size
    */
   public InvalidFontSizeException(int invalidSize)
   {
      super("Invalid font size "+invalidSize);
      invalidSize_ = invalidSize;
   }

   /**
    * Initialises with the given message and invalid size.
    * @param message error message
    * @param invalidSize invalid size
    */
   public InvalidFontSizeException(String message, int invalidSize)
   {
      super(message);
      invalidSize_ = invalidSize;
   }

   /**
    * Initialises with the given message and invalid size.
    * @param message error message
    * @param invalidSize invalid size
    * @param line line number
    */
   public InvalidFontSizeException(String message, int invalidSize, int line)
   {
      super(message, line);
      invalidSize_ = invalidSize;
   }

   /**
    * Gets the invalid font size.
    * @return invalid font size
    */
   public int getInvalidSize()
   {
      return invalidSize_;
   }

   private int invalidSize_;
}
