// File          : InvalidCapStyleException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2007
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// error.invalid_cap
/**
 * Exception thrown when an invalid cap style is used.
 * @author Nicola L C Talbot
 */
public class InvalidCapStyleException extends InvalidFormatException
{
   /**
    * Initialises indicating the invalid style.
    * @param invalidStyle invalid cap style
    */
   public InvalidCapStyleException(int invalidStyle)
   {
      super("Invalid cap style "+invalidStyle);
      invalidStyle_ = invalidStyle;
   }

   /**
    * Initialises indicating the invalid style and the line number
    * where the error occurred.
    * @param invalidStyle invalid cap style
    * @param line line number
    */
   public InvalidCapStyleException(int invalidStyle, int line)
   {
      super("Invalid cap style "+invalidStyle+" on line "+line);
      invalidStyle_ = invalidStyle;
      lineNum = line;
   }

   /**
    * Gets the invalid style.
    * @return invalid cap style
    */
   public int getInvalidStyle()
   {
      return invalidStyle_;
   }

   /**
    * Gets the line number.
    * @return line number or -1 if none specified
    */
   public int getLineNum()
   {
      return lineNum;
   }

   private int invalidStyle_;
   private int lineNum=-1;
}
