// File          : EmptyPathException.java
// Date          : 1st February 2006
// Last Modified : 13th March 2008
// Author        : Nicola L.C. Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

package uk.ac.uea.cmp.nlct.jdr;

// internal_error.empty_path
/**
 * Exception thrown when non-empty path is required.
 */
public class EmptyPathException extends InvalidPathException
{
   /**
    * Initialises with the message "Empty path".
    */
   public EmptyPathException()
   {
      super("Empty Path");
   }

   /**
    * Initialises with the given message.
    * @param message error message
    */
   public EmptyPathException(String message)
   {
      super(message);
   }
}
