// File          : Ajr2Tex.java
// Description   : command line ajr to tex converter
// Date          : 5 June 2007
// Last Modified : 1 October 2009
// Author        : Nicola L C Talbot
//                 http://theoval.cmp.uea.ac.uk/~nlct/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package uk.ac.uea.cmp.nlct.ajr2tex;

import java.io.*;
import uk.ac.uea.cmp.nlct.jdr.*;
import uk.ac.uea.cmp.nlct.jdr.io.*;

/**
 * AJR to TeX command line converter.
 */

public class Ajr2Tex
{
   /**
    * Prints version information to STDERR.
    */
   public static void appVersion()
   {
      System.err.println("ajr2tex 1.5");
      System.err.println("Copyright (C) 2007 Nicola L C Talbot");
      System.err.println("This is free software distributed under the GNU General Public License.");
      System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
   }

   /**
    * Prints syntax to STDERR and exits.
    */
   public static void syntax(int exitCode)
   {
      System.err.println("Syntax: ajr2tex [-version] [-doc] <ajr file> <tex file>");
      System.exit(exitCode);
   }

   public static void main(String[] args)
   {
      String ajrFile = null;
      String texFile = null;
      boolean doc = false;

      JDR.messageSystem.suspend();

      for (int i = 0; i < args.length; i++)
      {
         if (args[i].equals("-version"))
         {
            appVersion();
            System.exit(0);
         }
         else if (args[i].equals("-doc"))
         {
            doc = true;
         }
         else if (args[i].equals("-help"))
         {
            syntax(0);
         }
         else if (args[i].startsWith("-"))
         {
            System.err.println("Unknown switch '"+args[i]+"'");
            syntax(1);
         }
         else if (ajrFile == null)
         {
            ajrFile = args[i];
         }
         else if (texFile == null)
         {
            texFile = args[i];
         }
         else
         {
            System.err.println("Too many file names specified");
            syntax(1);
         }
      }

      if (ajrFile == null)
      {
         System.err.println("Missing input file");
         syntax(1);
      }
      else if (texFile == null)
      {
         System.err.println("Missing output file");
         syntax(1);
      }

      BufferedReader in=null;

      try
      {
         in = new BufferedReader(new FileReader(ajrFile));
      }
      catch (IOException e)
      {
         System.err.println("Unable to open "
            +e.getMessage());
         System.exit(1);
      }
      catch (Exception e)
      {
         System.err.println(e);
         System.exit(1);
      }

      String fileVersion = "";
      CanvasSettings settings = new CanvasSettings();
      JDRGroup paths=null;

      try
      {
         paths = AJR.load(in, settings);
      }
      catch (InvalidFormatException e)
      {
         System.err.println(e.getMessage());
         System.exit(1);
      }
      catch (EOFException e)
      {
         System.err.println("Unexpected EOF. (File corrupt?)");
         System.exit(1);
      }
      catch (Exception e)
      {
         System.err.println(e);
         System.exit(1);
      }

      try
      {
         in.close();
      }
      catch (Exception e)
      {
         System.err.println(e);
         System.exit(1);
      }


      PrintWriter out=null;

      try
      {
         out = new PrintWriter(new File(texFile));
      }
      catch (IOException e)
      {
         System.err.println("Unable to open "+e.getMessage());
         System.exit(1);
      }
      catch (Exception e)
      {
         System.err.println(e);
         System.exit(1);
      }

      try
      {
         if (doc)
         {
            PGF.saveDoc(paths, settings.paper, 
               new LaTeXFontBase(settings.normalsize),
               "", out, "ajr2tex");
         }
         else
         {
            PGF.save(paths, out, "ajr2tex");
         }
      }
      catch (Exception e)
      {
         System.err.println(e);
         System.exit(1);
      }

      try
      {
         out.close();
      }
      catch (Exception e)
      {
         System.err.println(e);
         System.exit(1);
      }
   }
}
