; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "Jpgfdraw"
#define MyAppVersion "VERSION"
#define MyAppPublisher "Nicola L. C. Talbot"
#define MyAppURL "http://www.dickimaw-books.com/apps/jpgfdraw/"
#define MyAppExeName "jpgfdraw.bat"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{90F3B25B-35A2-4B97-9879-278E2388898D}}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}
DefaultGroupName={#MyAppName}
LicenseFile=Z:\home\ezn06edu\programming\java\jpgfdraw\dist\jpgfdraw-{#MyAppVersion}\lib\resources\LICENSE
OutputDir=Z:\home\ezn06edu\programming\java\jpgfdraw\dist\jpgfdraw
OutputBaseFilename=jpgfdraw-{#MyAppVersion}-setup
Compression=lzma
SolidCompression=yes
ChangesAssociations=yes

[Registry]
; Associate file extensions:
Root: HKCR; Subkey: ".jdr"; ValueType: string; ValueName: ""; ValueData: {#MyAppName}; Flags: uninsdeletevalue
Root: HKCR; Subkey: ".ajr"; ValueType: string; ValueName: ""; ValueData: {#MyAppName}; Flags: uninsdeletevalue
; Specify the name of the file type as shown in Explorer
Root: HKCR; Subkey: "{#MyAppName}"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Flags: uninsdeletekey 
; Specify the filename containing the icon to associate with the
; file type. ",0" tells Explorer to use the first icon from that
; file
Root: HKCR; Subkey: "{#MyAppName}\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\jpgfdraw.ico,0" 
; Specify the program to execute when a file of this type is
; double-clicked in Explorer:
Root: HKCR; Subkey: "{#MyAppName}\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\jpgfdraw.bat"" ""%1""" 

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "Z:\home\ezn06edu\programming\java\jpgfdraw\dist\jpgfdraw-{#MyAppVersion}\bin\*.bat"; DestDir: "{app}\bin"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "Z:\home\ezn06edu\programming\java\jpgfdraw\dist\jpgfdraw-{#MyAppVersion}\doc\*"; DestDir: "{app}\doc"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "Z:\home\ezn06edu\programming\java\jpgfdraw\dist\jpgfdraw-{#MyAppVersion}\lib\*"; DestDir: "{app}\lib"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\bin\jpgfdraw.bat"; IconFilename: "{app}\lib\icons\jpgfdraw.ico"
Name: "{group}\JDRView"; Filename: "{app}\bin\jdrview.bat"; IconFilename: "{app}\lib\icons\jpgfdraw.ico"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
Name: "{group}\Jpgfdraw Manual"; Filename: "{app}\doc\jpgfdraw-en-GB.pdf"
Name: "{group}\Jdrview Manual"; Filename: "{app}\doc\jdrview-en-GB.pdf"
Name: "{group}\Jdrutils Manual"; Filename: "{app}\doc\jdrutils-en-GB.pdf"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\bin\jpgfdraw.bat"; IconFilename: "{app}\lib\icons\jpgfdraw.ico"; Tasks: desktopicon

; functions taken from
; http://stackoverflow.com/questions/1297773/check-java-is-present-before-installing
; Both DecodeVersion and CompareVersion functions where taken from the  wiki

[Code]
procedure DecodeVersion (verstr: String; var verint: array of
Integer);
var
  i,p: Integer; s: string;
begin
  // initialize array
  verint := [0,0,0,0];
  i := 0;
  while ((Length(verstr) > 0) and (i < 4)) do
  begin
    p := pos ('.', verstr);
    if p > 0 then
    begin
      if p = 1 then s:= '0' else s:= Copy (verstr, 1, p - 1);
      verint[i] := StrToInt(s);
      i := i + 1;
      verstr := Copy (verstr, p+1, Length(verstr));
    end
    else
    begin
      verint[i] := StrToInt (verstr);
      verstr := '';
    end;
  end;

end;

function CompareVersion (ver1, ver2: String) : Integer;
var
  verint1, verint2: array of Integer;
  i: integer;
begin

  SetArrayLength (verint1, 4);
  DecodeVersion (ver1, verint1);

  SetArrayLength (verint2, 4);
  DecodeVersion (ver2, verint2);

  Result := 0; i := 0;
  while ((Result = 0) and ( i < 4 )) do
  begin
    if verint1[i] > verint2[i] then
      Result := 1
    else
      if verint1[i] < verint2[i] then
        Result := -1
      else
        Result := 0;
    i := i + 1;
  end;

end;

function InitializeSetup(): Boolean;
var
 ErrorCode: Integer;
 Reply: Integer;
 JavaInstalled : Boolean;
 Result1 : Boolean;
 Versions: TArrayOfString;
 I: Integer;
begin
 if RegGetSubkeyNames(HKLM, 'SOFTWARE\JavaSoft\Java Runtime Environment', Versions) then
 begin
  for I := 0 to GetArrayLength(Versions)-1 do
   if JavaInstalled = true then
   begin
    //do nothing
   end else
   begin
    if ( Versions[I][2]='.' ) and ( ( StrToInt(Versions[I][1]) > 1 )
or ( ( StrToInt(Versions[I][1]) = 1 ) and ( StrToInt(Versions[I][3]) >= 6 ) ) ) then
    begin
     JavaInstalled := true;
    end else
    begin
     JavaInstalled := false;
    end;
   end;
 end else
 begin
  JavaInstalled := false;
 end;


 if JavaInstalled then
 begin
  Result := true;
 end else
    begin
  Reply := MsgBox('This application you are trying to install requires Java Runtime Environment version 1.6 or newer to run, but the installer can not detect it. Do you want to download it now? (Select "Yes" to quit the installer and redirect web browser to http://www.java.com/getjava/, select "No" to continue installing, or select "Cancel" to quit the installer)',
   mbConfirmation, MB_YESNOCANCEL);
  if Reply = idNo then
  begin
   Result:=true;
  end else
  begin
   Result:=false;
   if Reply = idYes then
   begin
     ShellExec('open',
      'http://www.java.com/getjava/',
      '','',SW_SHOWNORMAL,ewNoWait,ErrorCode);
   end;
  end;
    end;
end;



end.



[Run]
Filename: "{cmd}"; Parameters: "/C ""{app}\bin\jpgfdraw.bat"" "

