#!/usr/bin/perl -w
# File        : transdict.pl
# Author      : Nicola L C Talbot
# Description : Converts language/dictionary.txt file into
#               a \LaTeX\ file for use with the manual. (To make
#               it easier to update manual if menu names/items 
#               change.)

# transdict.pl <in file>
# read <in file>
# and write to dictionary.tex

unless ($#ARGV == 0)
{
   die "Syntax : $0 <dictionary file>\n";
}

$infile = $ARGV[0];

my $outfile = $infile;

$outfile=~s/\.([^\.]+)$//;

$outfile .= ".tex";

open INFD, $infile or die "Unable to open '$infile' $!\n";

open OUTFD, ">$outfile"
   or die "Unable to open '$outfile' $!\n";

while (<INFD>)
{
   # remove comments
   s/#.*//;

   chomp;

   # skip blank lines
   next if m/^[\s]*$/;

   if (m/([^=]*)=(.*)/)
   {
      $key = $1;
      $val = $2;
      $val=~s/\\n/ /g;
      $val=~s/%/\\%/g;

      $val=~s/\.\.\./\\ensuremath{\\ldotp\\ldotp\\ldotp}\\spacefactor=1000\\relax/g;
      print OUTFD "\\defjpgfdrawstring{$key}{$val}\n";
   }
   else
   {
      die "<key>=<value> pair expected on input line $.\n";
   }
}

close OUTFD;
close INFD;

1;
