.PS
# InclepsSVG.m4 : Illustrating one way to import and overwrite jpg in svg
#                 A bit messy, but it works.  This file has to be processed
#                 by m4 in the usual way and then twice by dpic, eg
# m4 svg.m4 SVGconfig.m4 InclepsSVG.m4 > InclepsSVG.pic
# dpic -v InclepsSVG.pic > InclepsSVG.svg
# dpic -v InclepsSVG.pic > InclepsSVG.svg

include(darrow.m4)
divert(-1)
######################################################################
# Some macros are defined to simplify inclusion of multiple jpg files:

                          `start_SVGinsertJPG(Unique_name)
                           Put this (once) before all drawing commands
                           It puts the total diagram into a [] block.

                           If there is a crash compiling the diagram,
                           you may have to delete Unique_name.dim
                           before trying again. '
define(`start_SVGinsertJPG',
`define(`M4_SVG_uniq',`ifelse(`$1',,SVGinsertTemp,`$1')')
 m4SVG_ht = 0; m4SVG_wid = 0
 sh "touch M4_SVG_uniq.dim"
 copy "M4_SVG_uniq.dim"
 [')

                          `SVGinsertJPG(filename, SymbolicName,
                             wid, ht, [svgdpi])
                           Insert jpg or png picture at the current location
                           as if it were a box, eg
                             SVGinsertJPG(Incl.jpg,Incl,242/150,321/150)
                           arg1= path to jpg or png file
                           arg2= dpic name to be given to the inserted picture
                           arg3= picture width in drawing units
                           arg4= picture height in drawing units
                           arg5= svg display dpi (default 90)
                           This macro works only at the top [] block depth
                           of the diagram '
define(`SVGinsertJPG',`define(`m4svgdpi',ifelse(`$5',,90,`$5'))
 `$2': box invis wid `$3' ht `$4'
 if m4SVG_ht!=0 then {
 command sprintf("<image x=\"%g\" y=\"%g\" width=\"%g\" height=\"%g\"
  xlink:href=\"`$1'\" />", \
    round_(`$2'_NW.x*scale*m4svgdpi),\
    round_((m4SVG_ht-`$2'_NW.y)*scale*m4svgdpi),\
    round_(`$3'*scale*m4svgdpi),\
    round_(`$4'*scale*m4svgdpi)) }
  pushdef(`SVGIGnames',$2)
')

                          `Put this at the end of the diagram'
define(`end_SVGinsertJPG',`]
  print sprintf("m4SVG_ht=%g; m4SVG_wid=%g",last [].ht,last [].wid) \
    > "M4_SVG_uniq.dim"
  stackexec_(`SVGIGnames',,`
  print sprintf("SVGIGnames`'_NW: (%g,%g)",\
    last [].SVGIGnames.nw.x-last [].sw.x,\
    last [].SVGIGnames.nw.y-last [].sw.y)\
    >>"M4_SVG_uniq.dim"') ')

######################################################################
divert(0)dnl

start_SVGinsertJPG(InclepsSVG)

  SVGinsertJPG(Incl.jpg,Picture,242/150,321/150)

  define(`backarrow',`darrow(`$1',,,2pt__,6pt__,6pt__,<-|)')
  thinlines_
  backarrow( from boxcoord(Picture,0.4,0.95) up 0.4 right 0.7 )
    "Basket" wid 0.45 with .w at Here+(2bp__,0)
  backarrow( from boxcoord(Picture,0.9,0.41) up 0.2 right 0.5 )
    "Ball" wid 0.3 with .w at Here+(2bp__,0)
  backarrow( from boxcoord(Picture,0.85,0.32) up 0.2 right 0.5 )
    "Star" wid 0.3 with .w at Here+(2bp__,0)
    "Player" wid 0.43 with .w at last "".w+(0,-0.15)

end_SVGinsertJPG

#showbox_

.PE
