% ex17.m4
.PS
cct_init

[
nrows = 4
ncols = 9
linewid = linewid*0.6          # everything smaller
define(`elen_',linewid)        # shorter default length

   for j = 1 to nrows do {
      { for i = 1 to ncols do {
           Point_(-120) resistor
           Point_(   0) resistor
           Point_( 120) resistor
           if i < ncols then {Point_(0) resistor} }
        }
      Point_(-120) move to rvec_(elen_,0)
      { for i = 1 to ncols do {
            Point_(-60) resistor
            Point_( 60) resistor }
         }
      Point_(-60) move to rvec_(elen_,0)
      }
   Point_(0) for i = 1 to ncols-1 do { resistor }
]

[                              # an exercise of the `gpar_' macro:
  down_                        # for labelling
  Point_(-80)                  # skew current direction

  gpar_(
        gpar_(capacitor(,C); rlabel(,,C_2),
              resistor; llabel(,R_2),
              ),
        gpar_(resistor; rlabel(,R_1); move to rvec_(-dimen_/5,0)
                inductor(,W); rlabel(,L_1),
              reversed(`source',to rvec_(elen_,0),V,sourcerad_*2.5)
              rlabel(,v_s),
              ),
        1.75*dimen_)

] with .sw at last [].se+(elen_,0)
.PE
