% Waveforms.m4
.PS
s_init(Waveforms)
sinclude(tst.dim)
No: dot; { s_box($N_o$) rjust above }
  up_; Point_(60); inductor; rlabel(,e_2); R2: Here
  move to No; down_; Point_(-60); inductor; rlabel(,e_3); R3: Here
  move to No; reversed(`inductor',left_ elen_); rlabel(,e_1); R1: Here
  line down_ No.y-R3.y
  D1: diode(down_ dimen_); b_current(i_1,below_)
  B: line to (R3,Here); { dot(at B) }
  D3: diode(down_ from R3 to Here); b_current(i_3,below_)
  D2: diode(down_ from (B,R3) to B); b_current(i_2,below_)
  line from R2 to ((1.2 between No and R1),R2) then down R2.y-D2.start.y \
    then to D2.start
  arrowline(down elen_/2 from B); rlabel(,i_d)
  Rd: resistor(right_ to (1.2*(R3.x-D2.x),Here.y))
    rlabel(+,e_d,-); llabel(,R_d)
  line to (Here,No) then to No

  tp = elen_*2
  thinlines_
  linethick_(0.4)
  A1: arrow from (Rd.end,No)+(dimen_/2,0) right_ 1.55*tp; s_box($t$) ljust 
  s_box($N_o$) at A1.start rjust above

define(`wave',
 `sinusoid(`$1',twopi_/tp,`$2',(`$3')/360*tp,(`$4')/360*tp,`$5') \
    with .Origin at `$6'.start')

  linethick_(0.8)
  a = dimen_
  aa = a*0.9
  ph1 = -90*dtor_
  ph2 = (-120-90)*dtor_
  ph3 = (120-90)*dtor_
  wave(a,ph1,0,540,,A1)
  s_box($e_1$) at A1.start+(tp/4,a) ljust above
  wave(a,ph2,0,540,,A1)
  s_box($e_2$) at A1.start+(tp/4+tp/3,a) ljust above
  wave(a,ph3,0,540,,A1)
  s_box($e_3$) at A1.start+(tp/4+tp/3*2,a) ljust above

  linethick_(0.4)
  A2: arrow from A1.start+(0,-2*a) right_ 1.55*tp; s_box($t$) ljust 
  s_box($N_o$) at A2.start rjust above
  wave(a,ph3,0,60,dashed,A2)
  wave(a,ph1,0,180,dashed,A2)
  wave(a,ph2,120,300,dashed,A2)
  wave(a,ph3,240,420,dashed,A2)
  wave(a,ph1,360,540,dashed,A2)
  wave(a,ph2,480,540,dashed,A2)
  linethick_(0.8)
  wave(aa,ph3,0,30,,A2)
  wave(aa,ph1,30,150,,A2)
  wave(aa,ph2,150,270,,A2)
  wave(aa,ph3,270,390,,A2)
  wave(aa,ph1,390,510,,A2)
  wave(aa,ph2,510,540,,A2)

  ab = aa*0.9
  linethick_(0.4)
  A3: arrow from A2.start+(0,-1.5*a) right_ 1.55*tp; s_box($t$) ljust 
  s_box($`0'$) at A3.start rjust above
  linethick_(0.8)
  wave(ab,ph3,0,30,,A3)
  wave(ab,ph1,30,150,,A3)
  wave(ab,ph2,150,270,,A3)
  wave(ab,ph3,270,390,,A3)
  wave(ab,ph1,390,510,,A3)
  wave(ab,ph2,510,540,,A3)
.PE
